/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    DM814x_ioexpander.h
 *
 * \brief   Defines the module register defines for Common IOExpander
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814X EVM IO EXPANDER common functions.
 *
 * \author  0586
 *
 * \version 01a,14oct,2010 Created.
 */

#ifndef _CENT_IO_EXPND_H_
#define _CENT_IO_EXPND_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */

/*
 *====================
 * Enumerations
 *====================
 */
//<< PUT CORRECT COPYRIGHT NOTICE HERE >>

/**
 * \file    DM814x_i2cGpioExp.c
 *
 * \brief   I2C routines for DM814x EVM
 *
 * This file contains the routines for configuring and
 * accessing the I2C controller and slave devices.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_types.h"
#include "DM814x_i2c.h"
#include "DM814x_EVM.h"

#include "stdio.h"

/*
 *====================
 * Defines
 *====================
*/

/*
 *====================
 * Function implementations
 *====================
 */
 /****************************************************************************
 * \n \brief Routine to Initialize the PCF8575 I2C based IO expander.
 *
 * This routine initialzes the I2C controller being used for the purpose and also
 * probes the I2C io expander. It returns success only if both the I2C controller
 * initialization succeeded as well as the Probe for the I2C GPIO expander is 
 * successful.
 *
 * \param u8I2cBusNum   [IN]    I2C Bus instance number [0, 1, 2, 3]
 * \param u8SlaveAddr   [IN]    I2C slave address of the IO Expander
 *
 * \return
 * \n      return SUCCESS for success  - Description 
 * \n      return FAILED for errors.
 * 
 */
STATUS i2cIoExpInit 
(
    UINT8 u8I2cBusNum, 
    UINT8 u8SlaveAddr
);

/** **************************************************************************
 * \n \brief Routine to get the states of IO Lines of the PCF8575
 *
 * This routine gets the states of switches.It takes states of the Switches 
 * as a parameter.
 *
 * \param u8I2cBusNum   [IN]    I2C bus number [0, 1, 2, 3]
 * \param u8SlaveAddr   [IN]    Slave address of the IO Expander
 * \param *pu16Val		[OUT]	buffer pointer which has the states of the 
 *                              switches.
 *
 * \return
 * \n      return SUCCESS for success  - Description 
 * 
 */
STATUS i2c0IoExpStatusGet
( 
    UINT8 u8I2cBusNum, 
    UINT8 u8SlaveAddr, 
    UINT16* pu16Val 
); 

/** **************************************************************************
 * \n \brief Routine to set the state of all IO lines at the same time
 *
 * This routine sets single LED.It takes num as paramter which gives Led number
 * along with that state that LED to be made.
 * 
 * \param u8I2cBusNum   [IN]    I2C bus instance number [0, 1, 2, 3]
 * \param u8SlaveAddr   [IN]    Slave address of the IO Expander
 * \param u8Index		[IN]	Index number of the bit to be set 0 - 15.
 * \param u8State       [IN]    State to be set/reset
 * 
 * \return
 * \n      return SUCCESS on successful completion of the routine
 * 
 */
STATUS i2c0IoExpStatusBitSet
(
    UINT8 u8I2cBusNum,
    UINT8 u8SlaveAddr,
    UINT8 u8Index, 
    UINT8 u8State
);

/** **************************************************************************
 * \n \brief Routine to set all IO lines to be desired state.
 *
 * This routine sets the state IO lines on the GPIO Expander to the desired state
 * Be aware that this routine may also drive the input lines to the state given
 * as input parameter. It is recommended to use this routine only if all the iO
 * lines are used as output only lines. 
 *
 * \param u8I2cBusNum   [IN]    I2C bus instance number [0, 1, 2, 3]
 * \param u8SlaveAddr   [IN]    Slave address of the IO Expander
 * \param u16Output		[IN]	State of all IO Lines to be set
 * 
 * 
 * \return
 * \n      return SUCCESS on successful completion of the routine
 * 
 */

STATUS i2c0IoExpStatusSetAll
(
    UINT8  u8I2cBusNum,
    UINT8  u8SlaveAddr,
    UINT16 u16Output
);

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _CENT_IO_EXPND_H_ */
